/*
 * Decompiled with CFR 0.152.
 */
package qz;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.print.event.PrintJobEvent;

public class LogIt {
    public static boolean disableLogging = false;

    public static void log(Level lvl, String msg, Throwable t) {
        LogIt.log(LogIt.class.getName(), lvl, msg, t);
    }

    public static void log(String msg, Throwable t) {
        LogIt.log(Level.SEVERE, msg, t);
    }

    public static void log(Throwable t) {
        if (t instanceof InterruptedException) {
            LogIt.log(Level.WARNING, "JavaScript listener interrupted, probably due to a browser refresh.");
        } else {
            LogIt.log("Error", t);
            t.printStackTrace();
        }
    }

    public static void log(String className, Level lvl, String msg) {
        if (!disableLogging) {
            Logger.getLogger(className).log(lvl, msg);
        }
    }

    public static void log(String className, Level lvl, String msg, Throwable t) {
        if (!disableLogging) {
            Logger.getLogger(className).log(lvl, msg, t);
        }
    }

    public static void log(Level lvl, String msg) {
        LogIt.log(LogIt.class.getName(), lvl, msg);
    }

    public static void log(String msg) {
        LogIt.log(Level.INFO, msg);
    }

    public static void log(PrintJobEvent pje) {
        Level lvl;
        String msg = "Print job ";
        switch (pje.getPrintEventType()) {
            case 106: {
                lvl = Level.INFO;
                msg = msg + "data transfer complete.";
                break;
            }
            case 105: {
                lvl = Level.INFO;
                msg = msg + "has no more events.";
                break;
            }
            case 102: {
                lvl = Level.INFO;
                msg = msg + "job complete.";
                break;
            }
            case 104: {
                lvl = Level.WARNING;
                msg = msg + "requires attention.";
                break;
            }
            case 101: {
                lvl = Level.WARNING;
                msg = msg + "job canceled.";
                break;
            }
            case 103: {
                lvl = Level.SEVERE;
                msg = msg + "job failed.";
                break;
            }
            default: {
                return;
            }
        }
        LogIt.log(lvl, msg);
    }
}

