<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class ConexionCertificadorTest_model extends CI_Model {

    public function __construct() {
        parent::__construct();
    }

    // Obtener datos de conexión por sucursal
    public function getConexion($sucursal_id) {
        return $this->db->get_where('sma_clientes_certificador_conexion', [
            'sucursal_id' => $sucursal_id,
            'activo' => 1
        ])->row();
    }

    // Obtener token válido o generar uno nuevo
    public function getToken($conexion_id, $usuario, $nit) {
        $query = $this->db->get_where('sma_certificador_tokens', [
            'conexion_id' => $conexion_id,
            'usuario' => $usuario
        ]);
        $token_data = $query->row();

        $now = date('Y-m-d H:i:s');

        if ($token_data && $token_data->expiracion > $now) {
            return $token_data->token;
        } else {
            $token = $this->generateToken($conexion_id, $usuario, $nit);
            $expiracion = date('Y-m-d H:i:s', strtotime('+10 minutes'));

            if ($token_data) {
                $this->db->update('sma_certificador_tokens', [
                    'token' => $token,
                    'expiracion' => $expiracion,
                    'updated_at' => $now
                ], ['id' => $token_data->id]);
            } else {
                $this->db->insert('sma_certificador_tokens', [
                    'conexion_id' => $conexion_id,
                    'usuario' => $usuario,
                    'token' => $token,
                    'expiracion' => $expiracion,
                    'created_at' => $now,
                    'updated_at' => $now
                ]);
            }

            return $token;
        }
    }

    // Genera token llamando al endpoint del certificador
  private function generateToken($conexion_id, $usuario, $nit) {
    $conexion = $this->db->get_where('sma_clientes_certificador_conexion', ['id' => $conexion_id])->row();
    if (!$conexion) die('No existe conexion');

    $certificador = $this->db->get_where('sma_certificadores', ['id' => $conexion->certificador_id])->row();
    if (!$certificador) die('No existe certificador');

    $url = $certificador->api_path; // URL del certificador
    $username = $usuario; // probar sin GT. ni padding
    $password = $conexion->contrasena;

    $data = json_encode(['Username' => $username, 'Password' => $password]);

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);

    $response = curl_exec($ch);
    $error = curl_error($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    // Mostrar todo en pantalla para depuración
    echo "<pre>";
    echo "HTTP Code: $http_code\n";
    echo "Error cURL: $error\n";
    echo "Response: $response\n";
    echo "</pre>";
    die;
}

    // Prueba de conexión al SAT
    public function pruebaSAT($token) {
        $url = 'https://testnucgt.digifact.com/api/dte/shared_getdteinfo'; // ejemplo

        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json',
            'Authorization: ' . $token
        ]);
        curl_setopt($ch, CURLOPT_POST, false);

        $response = curl_exec($ch);
        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        if ($http_code == 200) {
            return json_decode($response, true);
        } else {
            return ['error' => 'No se pudo conectar, HTTP CODE: '.$http_code, 'response' => $response];
        }
    }
}
