<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Merma_model extends CI_Model
{
    public function getAllMermas()
    {
        return $this->db->get('sma_mermas')->result();
    }

    public function addMerma($data, $products)
    {
        $this->db->insert('sma_mermas', $data);
        $merma_id = $this->db->insert_id();

        if ($products && $merma_id) {
            foreach ($products as $product) {
                $item = [
                    'merma_id'   => $merma_id,
                    'product_id' => $product['product_id'],
                    'quantity'   => $product['quantity'],
                    'cost'       => $product['cost']
                ];
                $this->db->insert('sma_mermas_products', $item);
            }
        }

        return $merma_id;
    }

    public function getWarehouses()
    {
        return $this->db->get('sma_warehouses')->result();
    }
}
