<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Factura extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('admin/Factura_model');
        $this->load->helper('url');
        $this->load->library('session');
    }

    // Abrir modal para generar factura
    public function generar($sale_id) {
        // Verificar que no exista factura
        if ($this->Factura_model->ya_facturada($sale_id)) {
            echo json_encode(['error' => 'La venta ya tiene factura.']);
            return;
        }

        $data['sale_id'] = $sale_id;
        $this->load->view('factura/generar', $data);
    }

    // Guardar factura
    public function guardar() {
        $sale_id     = $this->input->post('sale_id');
        $nit_cliente = $this->input->post('nit_cliente');
        $branch_id   = $this->input->post('branch_id');
        $total_amount= $this->input->post('total_amount');
        $user_id     = $this->session->userdata('user_id');

        // Generar identificador único
        $uuid = 'TEMP-' . uniqid();
        $fecha = date('Ymd');

        // Rutas de archivos
        $pdf_name = "FACT-{$sale_id}-{$fecha}-{$uuid}.pdf";
        $xml_name = "FACT-{$sale_id}-{$fecha}-{$uuid}.xml";

        $pdf_path = FCPATH . "app/factura_files/pdf/{$pdf_name}";
        $xml_path = FCPATH . "app/factura_files/xml/{$xml_name}";

        // Guardar en la base de datos
        $this->Factura_model->guardar_factura([
            'sale_id' => $sale_id,
            'branch_id' => $branch_id,
            'user_id' => $user_id,
            'uuid' => $uuid,
            'pdf_path' => "app/factura_files/pdf/{$pdf_name}",
            'xml_path' => "app/factura_files/xml/{$xml_name}",
            'status' => 'issued',
            'created_at' => date('Y-m-d H:i:s'),
            'nit_cliente' => $nit_cliente,
            'total_amount' => $total_amount
        ]);

        echo json_encode(['success' => 'Factura generada correctamente.']);
    }

    // Cancelar factura
    public function cancelar($invoice_id) {
        $user_id = $this->session->userdata('user_id');
        $factura = $this->Factura_model->get_factura($invoice_id);

        if ($factura && $factura->status == 'issued') {
            $this->Factura_model->cancelar_factura($invoice_id, $user_id);
            echo json_encode(['success' => 'Factura cancelada correctamente.']);
        } else {
            echo json_encode(['error' => 'Factura no válida o ya cancelada.']);
        }
    }
}
