<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Fel extends MY_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->admin_model('FelInvoice_model'); // Carga el modelo FelInvoice_model
        $this->lang->admin_load('fel', $this->Settings->user_language); // Carga el archivo de idioma
    }

    public function emitir()
    {
        $ticket = $this->input->post('ticket');
        $nit    = $this->input->post('nit');
        $modo_prueba = $this->input->post('modo_prueba'); // Obtener el valor de modo_prueba

        try {
            // Obtener los datos de la conexión del certificador
            $sale = $this->db
                ->where('reference_no', $ticket)
                ->get('sma_sales')
                ->row_array();

            if (!$sale) {
                throw new Exception('Venta no encontrada');
            }

            $conexion = $this->db
                ->where('sucursal_id', $sale['warehouse_id'])
                ->where('activo', 1)
                ->get('sma_clientes_certificador_conexion')
                ->row();

            if (!$conexion) {
                throw new Exception('No hay certificador activo');
            }

            $username = $conexion->usuario;
            $taxid = $conexion->nit;

            $res = $this->FelInvoice_model->emitirDesdeSale($ticket, $nit, 'FACT', $modo_prueba, $taxid, $username);

            if ($modo_prueba) {
                // Enviar datos a la vista para mostrar el modal de prueba
                $this->data['cliente'] = $res['cliente'];
                $this->data['json'] = $res['json'];
                $this->data['reference_no'] = $ticket;
                $this->data['taxid'] = $taxid;
                $this->data['username'] = $username;

                $this->load->view('admin/fel/modal_prueba', $this->data); // Reemplaza con la ruta correcta a tu vista
            } else {
                // Enviar respuesta JSON si no es modo de prueba
                echo json_encode([
                    'status' => true,
                    'uuid'   => $res['uuid'] ?? '',
                    'ticket' => $res['ticket'],
                ]);
            }
        } catch (Exception $e) {
            echo json_encode([
                'status' => false,
                'msg'    => $e->getMessage()
            ]);
        }
    }

    public function certificar()
    {
        $reference_no = $this->input->post('reference_no');
        $nit          = $this->input->post('nit');
        $direccion    = $this->input->post('direccion');
        $municipio    = $this->input->post('municipio');
        $departamento = $this->input->post('departamento');
        $json = $this->input->post('json'); // Obtener el JSON del formulario
        $taxid = $this->input->post('taxid');
        $username = $this->input->post('username');

        try {
            // Obtener la venta
            $sale = $this->db
                ->where('reference_no', $reference_no)
                ->get('sma_sales')
                ->row_array();

            if (!$sale) {
                throw new Exception('Venta no encontrada');
            }

            // Modificar los datos del cliente en la base de datos (si es necesario)
            if (strtoupper($nit) == 'CF') {
                $data = [
                    'address' => $direccion,
                    'city'      => $municipio,
                    'state'     => $departamento,
                ];

                $this->db
                    ->where('id', $sale['customer_id'])
                    ->update('sma_companies', $data);
            }

            // Llamar a la función sendDigifact() directamente con el JSON
            $this->load->admin_model('Certificadores_model', 'cert');
            $conexion = $this->db
                ->where('sucursal_id', $sale['warehouse_id'])
                ->where('activo', 1)
                ->get('sma_clientes_certificador_conexion')
                ->row();

            if (!$conexion) {
                throw new Exception('No hay certificador activo');
            }

            $certificador = $this->cert->get_certificador($conexion->certificador_id);
            $tokenFEL = $this->cert->get_token_valido($certificador, $conexion);

            // Decodificar el JSON antes de enviarlo a sendDigifact
            $jsonData = json_decode($json, true);

            $response = $this->FelInvoice_model->sendDigifact($jsonData, $tokenFEL, $taxid, $username);

            if (empty($response['uuid'])) {
                throw new Exception('Certificador no devolvió UUID');
            }

            // Guardar la información de la factura
            $cliente = [
                'vat_no' => $nit,
                'name' => $this->input->post('nombre'),
                'address' => $direccion,
                'municipio' => $municipio,
                'departamento' => $departamento,
                'pais' => $this->input->post('pais')
            ];
            $this->FelInvoice_model->saveInvoice($sale, $cliente, $response, 'FACT');

            echo json_encode([
                'status' => true,
                'uuid'   => $response['uuid'] ?? '',
                'ticket' => $reference_no,
            ]);
        } catch (Exception $e) {
            echo json_encode([
                'status' => false,
                'msg'    => $e->getMessage(),
            ]);
        }
    }
}