<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Ruta extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('Ruta_model');
    }

    // Devuelve JSON con los datos del cliente
    public function cliente($sale_id = null) {
    if (!$sale_id) {
        echo json_encode(['error' => 'ID de venta no proporcionado']);
        return;
    }

    $cliente = $this->Ruta_model->getCustomerLocationBySale($sale_id);

    if ($cliente) {
        echo json_encode([
            'lat' => $cliente->latitude ? floatval($cliente->latitude) : null,
            'lng' => $cliente->longitude ? floatval($cliente->longitude) : null,
            'nombre' => $cliente->name
        ]);
    } else {
        echo json_encode(['error' => 'Cliente no encontrado']);
    }
}

