$(document).ready(function(){

    // Buscar ticket
    $('#buscar_ticket').click(function(){
        var ref = $('#ticket_ref').val();
        $.post('<?= site_url('admin/merma/buscar_ticket') ?>', {ticket_ref: ref}, function(data){
            var r = JSON.parse(data);
            if(r.success){
                $('#datos_ticket').show();
                $('#cliente').text(r.cliente);
                $('#sucursal').text(r.sucursal);
                $('#sucursal_id').val(r.sucursal_id);
            } else {
                alert('Ticket no encontrado');
            }
        });
    });

    // Buscar producto
    $('#buscar_producto').keyup(function(e){
        if(e.keyCode == 13){
            var term = $(this).val();
            $.post('<?= site_url('admin/merma/buscar_producto') ?>', {term: term}, function(data){
                var productos = JSON.parse(data);
                if(productos.length > 0){
                    var p = productos[0];
                    var row = '<tr data-id="'+p.id+'" data-code="'+p.code+'" data-cost="'+p.cost+'">';
                    row += '<td>'+p.name+'</td>';
                    row += '<td>'+p.code+'</td>';
                    row += '<td><input type="number" class="form-control cantidad" value="1"></td>';
                    row += '<td><button type="button" class="btn btn-danger eliminar">X</button></td></tr>';
                    $('#tabla_productos tbody').append(row);
                    $('#buscar_producto').val('');
                }
            });
        }
    });

    // Eliminar fila
    $(document).on('click', '.eliminar', function(){
        $(this).closest('tr').remove();
    });

    // Guardar merma
    $('#guardar_merma').click(function(){
        var productos = [];
        $('#tabla_productos tbody tr').each(function(){
            productos.push({
                id: $(this).data('id'),
                code: $(this).data('code'),
                cost: $(this).data('cost'),
                cantidad: $(this).find('.cantidad').val()
            });
        });

        var data = {
            ticket_ref: $('#ticket_ref').val(),
            cliente: $('#cliente').text(),
            sucursal_id: $('#sucursal_id').val(),
            nota: $('textarea[name="nota"]').val(),
            productos: productos
        };

        $.post('<?= site_url('admin/merma/guardar_merma') ?>', data, function(resp){
            var r = JSON.parse(resp);
            if(r.success){
                alert('Merma guardada correctamente');
                location.reload();
            } else {
                alert('Error al guardar la merma');
            }
        });
    });

});
