$(document).ready(function() {

    $('#form_venta').on('submit', function(e) {
        e.preventDefault(); // Detener submit temporalmente

        // Verificar que el navegador soporte geolocalización
        if (!navigator.geolocation) {
            alert('Permitir geolocalización, venta no guardada.');
            window.location.href = base_url + 'admin/sales';
            return;
        }

        // Obtener la ubicación
        navigator.geolocation.getCurrentPosition(
            function(position) {
                // Rellenar los campos ocultos
                $('#latitude').val(position.coords.latitude);
                $('#longitude').val(position.coords.longitude);

                // Depuración: imprimir valores
                console.log("Lat:", position.coords.latitude, "Lng:", position.coords.longitude);

                // Enviar el formulario al método done() del controlador
                e.currentTarget.submit();
            },
            function(error) {
                alert('Permitir geolocalización, venta no guardada.');
                window.location.href = base_url + 'admin/sales';
            },
            {
                enableHighAccuracy: true,
                timeout: 10000
            }
        );
    });

});
