<?php
$reference_no = $reference_no ?? ''; // recibimos reference_no desde la URL
?>
<!DOCTYPE html>
<html>
<head>
    <title>Facturación FEL</title>
    <link rel="stylesheet" href="<?= base_url('assets/bootstrap/css/bootstrap.min.css'); ?>">
    <script src="<?= base_url('assets/jquery/jquery.min.js'); ?>"></script>
    <script src="<?= base_url('assets/bootstrap/js/bootstrap.min.js'); ?>"></script>
</head>
<body>
<!-- Modal FEL -->
<div class="modal fade" id="felModal">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h4>¿Desea Facturar con FEL?</h4>
      </div>
      <div class="modal-body">
        <label>NIT:</label>
        <input type="text" id="fel_nit" class="form-control" placeholder="C/F">
      </div>
      <div class="modal-footer">
        <button id="btnSoloTicket" class="btn btn-secondary">Cancelar / Solo Ticket</button>
        <button id="btnFacturarFel" class="btn btn-danger">Facturar FEL</button>
      </div>
    </div>
  </div>
</div>

<script type="text/javascript">
$(document).ready(function() {
    // Mostrar modal al cargar
    $('#felModal').modal({
        backdrop: 'static',
        keyboard: false
    }).modal('show');

    // Cancelar / Solo Ticket
    $('#btnSoloTicket').click(function(){
        window.location.href = '<?= admin_url("pos/receipt/".$reference_no); ?>'; // Regresa al ticket normal
    });

    // Facturar FEL
    $('#btnFacturarFel').click(function(){
        let nit = $('#fel_nit').val() || 'C/F';

        // Enviar formulario o hacer AJAX a tu controlador para guardar FEL
        $.post('<?= admin_url("pos/save_fel"); ?>', {reference_no: '<?= $reference_no ?>', nit: nit}, function(response) {
            alert('Factura FEL guardada correctamente');
            // Redirigir al ticket normal después de guardar
            window.location.href = '<?= admin_url("pos/receipt/".$reference_no); ?>';
        });
    });
});
</script>
</body>
</html>
